<?php

    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    class FileScaricabile {
        private $db;
        private $id;
        private $idUtente;
        private $nome; 	 		
	private $password;	 		
	private $percorso;	 		
	private $descrizione; 	 		
	private $immagine;
	private $categoria;
        private $accessibilita;
	private $posizione; 			
	private $numeroDownload; 	 			
	private $dataCreazione; 
        
        public function __construct($db, $id, $idUtente = 0, $nome="", $password="", $percorso="", $descrizione="", $immagine="", $categoria=0, $accessibilita = "", $posizione=0, $numeroDownload=0, $dataCreazione="") {
            $this->db   = $db;
            $this->id   = $id;
            $this->idUtente       = $idUtente;
            $this->nome           = $nome;
            $this->password       = $password;
            $this->percorso       = $percorso;
            $this->descrizione    = $descrizione;
            $this->immagine       = $immagine;
            $this->categoria      = $categoria;
            $this->accessibilita  = $accessibilita;
            $this->posizione      = $posizione;
            $this->numeroDownload = $numeroDownload;
            $this->dataCreazione  = $dataCreazione;
        }

        public function crea() {
            $data     = date("Y-m-d");
            $query    = "INSERT INTO `geecAd_risorse` (`id`, `idUtente`, `nome`, `password`, `percorso`, `descrizione`, `immagine`, `categoria`,`accessibilita`, `posizione`, `numeroDownload`, `dataCreazione`) 
                            VALUES (NULL, '$this->idUtente', '$this->nome', '$this->password', '$this->percorso', '$this->descrizione', '$this->immagine', '$this->categoria', '$this->accessibilita', '$this->posizione', '$this->numeroDownload', '$data')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        public function modifica() {
            $query    = "UPDATE `geecAd_risorse` SET idUtente='$this->idUtente', nome='$this->nome', password='$this->password', percorso='$this->percorso', descrizione='$this->descrizione', immagine='$this->immagine', categoria='$this->categoria', accessibilita='$this->accessibilita', posizione='$this->posizione' WHERE id=$this->id";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        public function elimina() {
            $this->db->eseguiQueryCancellazione("geecAd_risorse",$this->id);
        }
        
        public function modificaImmagine($percorso) {
            $query    = "UPDATE `geecAd_risorse` SET immagine='$percorso' WHERE id=$this->id";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        public function aggiornaPercorsoFile($percorso) {
            $query    = "UPDATE `geecAd_risorse` SET percorso='$percorso' WHERE id=$this->id";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        public function caricaDatiDalDatabase() {
            $datiRisorsa  = $this->db->leggiSingolaRiga("geecAd_risorse",$this->id);
            if($datiRisorsa) { // se esiste l'occorrenza nel database
                $this->nome        = $datiRisorsa["nome"];
                $this->password    = $datiRisorsa["password"];
                $this->percorso    = $datiRisorsa["percorso"];
                $this->descrizione = $datiRisorsa["descrizione"];
                $this->immagine    = $datiRisorsa["immagine"];
                $this->categoria   = $datiRisorsa["categoria"];
                $this->accessibilita  = $datiRisorsa["accessibilita"];
                $this->posizione      = $datiRisorsa["posizione"];
                $this->numeroDownload = $datiRisorsa["numeroDownload"];
                $this->dataCreazione  = $datiRisorsa["dataCreazione"];
            }
        }
        
        public function duplica() {
            $data     = date("Y-m-d");
            $nomeEscape        = filter_var($this->nome,FILTER_SANITIZE_ADD_SLASHES);
            $descrizioneEscape = filter_var($this->descrizione,FILTER_SANITIZE_ADD_SLASHES);
            $query    = "INSERT INTO `geecAd_risorse` (`id`, `nome`, `password`, `percorso`, `descrizione`, `immagine`, `categoria`, `accessibilita`, `posizione`, `numeroDownload`, `dataCreazione`) 
                            VALUES (NULL, 'Copia di $nomeEscape', '$this->password', '$this->percorso', '$descrizioneEscape', '$this->immagine', '$this->categoria', '$this->accessibiita', '$this->posizione', '0', '$data')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function aggiungiAGruppo($idGruppo) {
            $query = "INSERT INTO `geecAd_gruppiDestinatari` VALUES (NULL, 0, '$this->id', '$idGruppo')";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getIdUtente() {
            return $this->idUtente;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getPassword() {
            return $this->password;
        }

        public function getPercorso() {
            return $this->percorso;
        }

        public function getDescrizione() {
            return $this->descrizione;
        }

        public function getImmagine() {
            return $this->immagine;
        }

        public function getCategoria() {
            return $this->categoria;
        }

        public function getAccessibilita() {
            return $this->accessibilita;
        }

        public function getPosizione() {
            return $this->posizione;
        }

        public function getNumeroDownload() {
            return $this->numeroDownload;
        }

        public function getDataCreazione() {
            return $this->dataCreazione;
        }

        public function setDb($db) {
            $this->db = $db;
        }

        public function setId($id) {
            $this->id = $id;
        }

        public function setIdUtente($idUtente) {
            $this->idUtente = $idUtente;
        }
        
        public function setNome($nome) {
            $this->nome = $nome;
        }

        public function setPassword($password) {
            $this->password = $password;
        }

        public function setPercorso($percorso) {
            $this->percorso = $percorso;
        }

        public function setDescrizione($descrizione) {
            $this->descrizione = $descrizione;
        }

        public function setImmagine($immagine) {
            $this->immagine = $immagine;
        }

        public function setCategoria($categoria) {
            $this->categoria = $categoria;
        }

        public function setAccessibilita($accessibilita) {
            $this->accessibilita = $accessibilita;
        }
        
        public function setPosizione($posizione) {
            $this->posizione = $posizione;
        }

        public function setNumeroDownload($numeroDownload) {
            $this->numeroDownload = $numeroDownload;
        }

        public function setDataCreazione($dataCreazione) {
            $this->dataCreazione = $dataCreazione;
        }
    }